//
//  NSColorHelpers.h
//  ContrastingLabelColor
//
//  Created by Matt Gemmell on 16/08/2006.
//  Copyright 2006 Magic Aubergine. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSColor (Helper)

- (NSColor *)contrastingLabelColor;

- (BOOL)isDark;

+ (NSColor *)colorWithString:(NSString *)string;

- (void)getSaveRed:(CGFloat *)red green:(CGFloat *)green blue:(CGFloat *)blue alpha:(CGFloat *)alpha;

- (void)getSaveRed:(CGFloat *)red green:(CGFloat *)green blue:(CGFloat *)blue alpha:(CGFloat *)alpha colorSpaceName:(NSColorSpaceName)name;

- (NSColor *)colorByAddingHue:(CGFloat)addHue addSaturation:(CGFloat)addSaturation addBrightness:(CGFloat)addBrightness;

- (NSColorType)typeSave;

- (NSColor *)componentBasedColor;

+ (NSColor *)colorWithHexString:(NSString *)hexString;
@end
